<?php
require_once 'config.php';

// Check API Key
if (ENABLE_API_KEY_CHECK) {
    $apiKey = $_SERVER['HTTP_X_API_KEY'] ?? $_GET['api_key'] ?? '';
    if ($apiKey !== API_KEY) {
        http_response_code(401);
        die(json_encode(['error' => 'Invalid API key']));
    }
}

$place_id = $_GET['place_id'] ?? null;
$map_version = $_GET['map_version'] ?? null;
$is_checkpoint = isset($_GET['is_checkpoint']) ? filter_var($_GET['is_checkpoint'], FILTER_VALIDATE_BOOLEAN) : false;
$checkpoint_index = $_GET['checkpoint_index'] ?? null;
$user_id = $_GET['user_id'] ?? null;
$username = $_GET['username'] ?? 'Guest';

if (!$place_id) {
    http_response_code(400);
    die(json_encode(['error' => 'place_id is required']));
}

try {
    $db = getDB();
    
    // Build query
    $query = "SELECT * FROM paths WHERE place_id = ?";
    $params = [$place_id];
    
    if ($map_version !== null) {
        $query .= " AND map_version = ?";
        $params[] = $map_version;
    }
    
    $query .= " AND is_checkpoint = ?";
    $params[] = $is_checkpoint;
    
    if ($is_checkpoint && $checkpoint_index !== null) {
        $query .= " AND checkpoint_index = ?";
        $params[] = $checkpoint_index;
    }
    
    $query .= " ORDER BY upload_date DESC LIMIT 1";
    
    $stmt = $db->prepare($query);
    $stmt->execute($params);
    $path = $stmt->fetch();
    
    if (!$path) {
        http_response_code(404);
        die(json_encode(['error' => 'Path not found']));
    }
    
    $filePath = UPLOAD_DIR . $path['file_path'];
    
    if (!file_exists($filePath)) {
        http_response_code(404);
        die(json_encode(['error' => 'File not found on server']));
    }
    
    // Log download
    try {
        $stmt = $db->prepare("
            INSERT INTO download_logs (path_id, user_id, username, ip_address)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([$path['id'], $user_id, $username, $_SERVER['REMOTE_ADDR']]);
        
        // Update download count
        $db->prepare("UPDATE paths SET downloads = downloads + 1 WHERE id = ?")->execute([$path['id']]);
    } catch (Exception $e) {
        // Log error but continue with download
    }
    
    // Return file content as JSON
    $content = file_get_contents($filePath);
    
    header('Content-Type: application/json');
    header('Content-Disposition: inline; filename="' . basename($filePath) . '"');
    header('Content-Length: ' . filesize($filePath));
    
    echo $content;
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
}
?>
