<?php
require_once 'config.php';

// Check API Key
if (ENABLE_API_KEY_CHECK) {
    $apiKey = $_SERVER['HTTP_X_API_KEY'] ?? $_GET['api_key'] ?? '';
    if ($apiKey !== API_KEY) {
        http_response_code(401);
        die(json_encode(['error' => 'Invalid API key']));
    }
}

$place_id = $_GET['place_id'] ?? null;

if (!$place_id) {
    http_response_code(400);
    die(json_encode(['error' => 'place_id is required']));
}

try {
    $db = getDB();
    
    // Get all versions for this place_id
    $stmt = $db->prepare("
        SELECT 
            map_version,
            MAX(upload_date) as latest_upload,
            COUNT(*) as file_count,
            SUM(downloads) as total_downloads
        FROM paths 
        WHERE place_id = ?
        GROUP BY map_version
        ORDER BY map_version DESC
    ");
    $stmt->execute([$place_id]);
    $versions = $stmt->fetchAll();
    
    if (empty($versions)) {
        echo json_encode([
            'success' => true,
            'versions' => [],
            'message' => 'No versions found for this place_id'
        ]);
        exit;
    }
    
    // Format response
    $result = [];
    foreach ($versions as $v) {
        $result[$v['map_version']] = [
            'version' => $v['map_version'],
            'upload_date' => $v['latest_upload'],
            'file_count' => $v['file_count'],
            'downloads' => $v['total_downloads']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'place_id' => $place_id,
        'versions' => $result,
        'latest_version' => $versions[0]['map_version']
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
}
?>
