<?php
require_once 'config.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>API Test - Motion Path</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #1e1e1e; color: #0f0; }
        .success { color: #0f0; }
        .error { color: #f00; }
        .info { color: #0ff; }
        pre { background: #000; padding: 10px; border-radius: 5px; }
    </style>
</head>
<body>
    <h1>🧪 Motion Path API Test</h1>
    
    <h2>1. Database Connection</h2>
    <?php
    try {
        $db = getDB();
        echo '<p class="success">✅ Database connected successfully!</p>';
        
        // Test query
        $result = $db->query("SELECT COUNT(*) as count FROM paths")->fetch();
        echo '<p class="info">📊 Total paths in database: ' . $result['count'] . '</p>';
        
    } catch (Exception $e) {
        echo '<p class="error">❌ Database connection failed: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
    ?>
    
    <h2>2. Upload Directory</h2>
    <?php
    if (is_dir(UPLOAD_DIR)) {
        echo '<p class="success">✅ Upload directory exists</p>';
        echo '<p class="info">📁 Path: ' . UPLOAD_DIR . '</p>';
        
        if (is_writable(UPLOAD_DIR)) {
            echo '<p class="success">✅ Upload directory is writable</p>';
        } else {
            echo '<p class="error">❌ Upload directory is NOT writable! Run: chmod 755 ' . UPLOAD_DIR . '</p>';
        }
    } else {
        echo '<p class="error">❌ Upload directory does not exist!</p>';
    }
    ?>
    
    <h2>3. Configuration</h2>
    <pre>
Database: <?= DB_NAME ?>

API Key: <?= substr(API_KEY, 0, 20) ?>...
Max Upload: <?= MAX_FILE_SIZE / 1024 / 1024 ?>MB
Allowed Extensions: <?= implode(', ', ALLOWED_EXTENSIONS) ?>
    </pre>
    
    <h2>4. API Endpoints</h2>
    <pre>
Upload:   <?= $_SERVER['REQUEST_SCHEME'] ?>://<?= $_SERVER['HTTP_HOST'] ?>/api/upload.php
Download: <?= $_SERVER['REQUEST_SCHEME'] ?>://<?= $_SERVER['HTTP_HOST'] ?>/api/download.php
List:     <?= $_SERVER['REQUEST_SCHEME'] ?>://<?= $_SERVER['HTTP_HOST'] ?>/api/list_versions.php
    </pre>
    
    <h2>5. Recent Uploads</h2>
    <?php
    try {
        $recent = $db->query("SELECT * FROM paths ORDER BY upload_date DESC LIMIT 5")->fetchAll();
        if (empty($recent)) {
            echo '<p class="info">ℹ️ No uploads yet</p>';
        } else {
            echo '<table border="1" cellpadding="5" style="color:#0f0;">';
            echo '<tr><th>Place ID</th><th>Version</th><th>Type</th><th>Upload Date</th></tr>';
            foreach ($recent as $p) {
                $type = $p['is_checkpoint'] ? 'CP #' . $p['checkpoint_index'] : 'Main';
                echo '<tr>';
                echo '<td>' . $p['place_id'] . '</td>';
                echo '<td>v' . $p['map_version'] . '</td>';
                echo '<td>' . $type . '</td>';
                echo '<td>' . $p['upload_date'] . '</td>';
                echo '</tr>';
            }
            echo '</table>';
        }
    } catch (Exception $e) {
        echo '<p class="error">❌ Error: ' . htmlspecialchars($e->getMessage()) . '</p>';
    }
    ?>
    
    <hr>
    <p style="color: #888;">Motion Path API v1.0 | <?= date('Y-m-d H:i:s') ?></p>
</body>
</html>
